////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/CryptoAppIndex.h>
NS_ASSUME_NONNULL_BEGIN

@protocol ChangePasswordDelegate;
@class OrchestrationUser;

/**
 * A {@link ChangePasswordParams} object provides parameters to change password of a specific user.
 */

NS_REFINED_FOR_SWIFT
@interface ChangePasswordParams : NSObject

/**
 * Gets the configured user identifier to be used to change the password.
 * Sets the user identifier to be used to change the password.
 */
@property (nonatomic, strong) OrchestrationUser *orchestrationUser;

/**
 * Gets the configured {@link ChangePasswordDelegate}.<br/>
 * Sets the {@link ChangePasswordDelegate} to be notified about change password events.
 */
@property (nonatomic, weak) id<ChangePasswordDelegate> changePasswordDelegate;

/**
 * Gets the cryptoAppIndex used to generate OTPs.
 * Sets the cryptoAppIndex that will be used to generate OTPs.
 */
@property (nonatomic) CryptoAppIndex cryptoAppIndex;

@end

NS_ASSUME_NONNULL_END
